/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tooltips;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class ClientTooltipIcon
implements ClientTooltipComponent,
TooltipComponent {
    protected List<Pair<ItemStack, Integer>> itemStack;
    protected int itemsPerLine;

    public ClientTooltipIcon(List<Pair<ItemStack, Integer>> pItemStack, int pItemsPerLine) {
        this.itemStack = pItemStack;
        this.itemsPerLine = pItemsPerLine;
    }

    public int m_142103_() {
        return Math.max(1, this.itemStack.size() / this.itemsPerLine * 20);
    }

    public int m_142069_(Font font) {
        return Math.min(this.itemsPerLine, this.itemStack.size()) * 21 + 4;
    }

    public void m_183452_(Font font, int offsetX, int offsetY, PoseStack pose, ItemRenderer itemRenderer, int p_174257_) {
        int j = 0;
        for (Pair<ItemStack, Integer> item : this.itemStack) {
            int x = offsetX + Math.floorMod(j, this.itemsPerLine) * 21;
            int y = offsetY + Math.floorDiv(j, this.itemsPerLine) * 20 - 20;
            itemRenderer.m_174253_((ItemStack)item.getLeft(), x, y, p_174257_);
            itemRenderer.m_115174_(font, (ItemStack)item.getLeft(), x, y, "");
            ClientTooltipIcon.renderItemCount(font, itemRenderer, x, y + 20, ((ItemStack)item.getLeft()).m_41613_(), (Integer)item.getRight());
            ++j;
        }
    }

    private static void renderItemCount(Font font, ItemRenderer itemRenderer, int x, int y, int count, int errorAmount) {
        if (errorAmount == -2) {
            return;
        }
        if (count == 1 && errorAmount == 0) {
            return;
        }
        MultiBufferSource.BufferSource buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        String s1 = count == Integer.MAX_VALUE ? "\u221e" : Integer.toString(count);
        PoseStack pose = new PoseStack();
        pose.m_85837_(0.0, 0.0, 200.0 + (double)itemRenderer.f_115093_);
        ClientTooltipIcon.drawStringToWidth(font, buffersource, pose, x, y, 18, 0xFFFFFF, s1);
        if (errorAmount >= 0) {
            String s2 = "(" + Integer.toString(errorAmount) + ")";
            ClientTooltipIcon.drawStringToWidth(font, buffersource, pose, x + 8, y + 17, 18, -65536, s2);
        }
        buffersource.m_109911_();
    }

    private static void drawStringToWidth(Font font, MultiBufferSource.BufferSource buffersource, PoseStack pose, int x, int y, int width, int color, String str) {
        pose.m_85836_();
        pose.m_85837_((double)(x + width), (double)y, 0.0);
        int strWidth = font.m_92895_(str);
        if (strWidth > width) {
            pose.m_85841_((float)width / (float)strWidth, (float)width / (float)strWidth, 1.0f);
        }
        float f = -strWidth;
        Objects.requireNonNull(font);
        font.m_92811_(str, f, (float)(-9), color, true, pose.m_85850_().m_85861_(), (MultiBufferSource)buffersource, false, 0, 0xF000F0);
        pose.m_85849_();
    }
}

